<?php

include 'koneksi.php';


// Fungsi untuk melakukan web scraping dan mengambil data nama produk, harga, dan link produk dari halaman utama

function scrapeHomePage($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);

    // Cek jika ada error saat melakukan request
    if (curl_errno($ch)) {
        echo 'Error saat mengambil data: ' . curl_error($ch);
        curl_close($ch);
        return;
    }

    curl_close($ch);

    $doc = new DOMDocument();
    libxml_use_internal_errors(true); // Matikan kesalahan libxml
    $doc->loadHTML($response);
    libxml_clear_errors();

    $products = array();
    $productElements = $doc->getElementsByTagName('div');

    foreach ($productElements as $productElement) {
        if ($productElement->getAttribute('class') === 'col-md-3 col-lg-3 col-6 mb-4') {
            // Kode scraping untuk mendapatkan data nama produk, harga, dan link produk
            $productName = '';
            $productPrice = '';
            $productLink = '';
            $productImage = '';

            // Ambil nama produk
            $titleElement = $productElement->getElementsByTagName('div')->item(1);
            $productName = $titleElement->nodeValue;

            // Ambil harga produk
            $priceElement = $productElement->getElementsByTagName('p')->item(0);
            $productPrice = $priceElement->nodeValue;

            // Ambil link produk
            $linkElement = $productElement->getElementsByTagName('a')->item(0);
            $productLink = $linkElement->getAttribute('href');

            // Ambil gambar produk
            $imageElement = $productElement->getElementsByTagName('img')->item(0);
            $productImage = $imageElement->getAttribute('src');

            $products[] = array(
                'name' => $productName,
                'price' => $productPrice,
                'link' => $productLink,
                'image' => $productImage,
            );
        }
    }

    return $products;
}


$kode = isset($_GET['kode']) ? $_GET['kode'] : '';
$kategori = isset($_GET['kategori']) ? $_GET['kategori'] : '';
$atur = '&urutan=murah';
$targetKode = isset($_GET['kode']) ? $_GET['kode'] : '';
$sql = "SELECT * FROM nama_tabel $where";
$result = $conn->query($sql);

$categoryUrl = ''; // Inisialisasi $categoryUrl di luar loop

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Tampilkan link_kategori jika kode sesuai
        if ($row['kode'] == $targetKode) {
            $categoryUrl = $row['link_kategori'] .$kategori;
            break; // Hentikan loop setelah menemukan kode yang sesuai
        }
    }
}

// Jika $categoryUrl masih kosong, set URL default
if (empty($categoryUrl)) {
    $categoryUrl = 'https://paymobileaja.bukaolshop.site/kategori/default-category';
}

$conn->close();





// Inisialisasi array untuk menyimpan hasil scraping dari semua halaman
$allProducts = array();

// Lakukan scraping untuk 4 halaman
for ($page = 1; $page <= 4; $page++) {
    // Buat URL untuk halaman saat ini
    $pageUrl = $categoryUrl . '&page=' . $page;
    
    // Panggil fungsi scrapeHomePage dengan URL halaman saat ini
    $result = scrapeHomePage($pageUrl);

    // Tambahkan hasil scraping ke array allProducts
    $allProducts = array_merge($allProducts, $result);
}

// Hitung jumlah produk yang ditemukan
$totalProducts = count($allProducts);

// Buat array response dengan total produk dan data produk
$response = array(
    'totalProducts' => $totalProducts,
    'products' => $allProducts
);

// Set header untuk menandakan bahwa response adalah JSON
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Header: *');

// Menggunakan json_encode untuk menghasilkan output JSON
echo json_encode($response);
?>