<?php

// Menambahkan header CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Max-Age: 86400");

// Handle preflight (OPTIONS) request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204); // No Content
    exit;
}

// URL tujuan
$url = 'https://kodebayar.web.id/Indosat/cari';

// Data yang akan dikirimkan
$data = [
    'nohp' => '08566211798',
    'ci_csrf_token' => ''
];

// Mengubah data menjadi format query string
$postData = http_build_query($data);

// Mengatur opsi untuk request
$options = [
    'http' => [
        'header'  => "Content-Type: application/x-www-form-urlencoded\r\n",
        'method'  => 'POST',
        'content' => $postData,
    ]
];

// Membuat konteks stream
$context = stream_context_create($options);

// Melakukan POST request
$result = file_get_contents($url, false, $context);

// Mengecek hasil
if ($result === FALSE) {
    echo json_encode(["status" => "error", "message" => "Request gagal"]);
} else {
    // Mengecek apakah hasil response adalah JSON
    $jsonResult = json_decode($result, true);
    
    if (json_last_error() === JSON_ERROR_NONE) {
        // Periksa dan hapus tag <div class="modal"> dan <div class="modal-body"> dalam field 'isi' jika ada
        if (isset($jsonResult['isi']) && is_string($jsonResult['isi'])) {
            // Menghapus tag <div class="modal"> beserta kontennya
            $jsonResult['isi'] = preg_replace('/<div[^>]*class=["\']modal["\'][^>]*>.*?<\/div>/is', '', $jsonResult['isi']);
            // Menghapus tag <div class="modal-body"> beserta kontennya
            $jsonResult['isi'] = preg_replace('/<div[^>]*class=["\']modal-body["\'][^>]*>.*?<\/div>/is', '', $jsonResult['isi']);
            $jsonResult['isi'] = preg_replace('/<div[^>]*class=["\']modal-footer justify-content-between["\'][^>]*>.*?<\/div>/is', '', $jsonResult['isi']);
            $jsonResult['isi'] = preg_replace('/<div[^>]*class=["\']overlay dark invisible["\'][^>]*>.*?<\/div>/is', '', $jsonResult['isi']);
        }

        // Ekstrak nama-nama tombol/menu dari string HTML yang ada di dalam 'menu'
        $menuButtons = [];
        if (isset($jsonResult['menu'])) {
            // Menggunakan regex untuk mencari teks dalam tag <button>
            preg_match_all('/<button[^>]*>(.*?)<\/button>/is', $jsonResult['menu'], $matches);
            
            // Masukkan setiap nama tombol yang ditemukan ke dalam array
            foreach ($matches[1] as $buttonName) {
                $menuButtons[] = trim($buttonName); // Menambahkan nama tombol ke dalam array
            }
        }

        // Menambahkan list menu ke dalam hasil JSON
        $jsonResult['menu'] = $menuButtons; // Menambahkan nama-nama tombol ke dalam field 'menu'

        // Menampilkan response sebagai JSON
        header('Content-Type: application/json'); 
        echo json_encode($jsonResult);
    } else {
        // Jika bukan JSON, tampilkan sebagai teks mentah
        header('Content-Type: text/plain'); 
        echo $result;
    }
}

?>
