<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <title>Upload dan Kelola Gambar</title>
</head>
<body>
  <div class="box">
    <form action="upload.php" method="post" enctype="multipart/form-data">
        <p>Upload Gambar Di Sini</p>
        <hr>
        <div style="text-align: center; margin: 30px 0px 30px 0px;">
            <label for="file" class="custom-file-upload">
                <img src="https://i.ibb.co/0Ddtd9b/image.png" alt="Upload Image" width="100" id="uploadImage">
                <input type="file" name="file" id="file" onchange="displayImage(this)">
            </label>
        </div>
        
        <input type="submit" value="Upload" name="submit">
    </form>
  </div>
    <div class="box">
    <table>
        <thead>
            <tr>
                <th>File</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
<?php
$imageExtensions = ['jpg', 'jpeg', 'png', 'gif'];
$files = glob('*');

foreach ($files as $file) {
    $fileExtension = pathinfo($file, PATHINFO_EXTENSION);

    if (is_file($file) && in_array($fileExtension, $imageExtensions)) {
        echo '<tr>';
        echo '<td><img src="' . $file . '" alt="' . $file . '" width="50" onclick="window.location.href=\'' . $file . '\'"></td>';
        echo '<td><a href="hapus.php?file=' . urlencode($file) . '">Hapus</a></td>';
        echo '</tr>';
    }
}
?>
        </tbody>
    </table>
</div>
    <?php
    // Logika penghapusan file
    if (isset($_GET['hapus'])) {
        $fileToDelete = $_GET['hapus'];
        if (file_exists($fileToDelete)) {
            unlink($fileToDelete);
            echo '<p class="success">File ' . $fileToDelete . ' berhasil dihapus.</p>';
        } else {
            echo '<p class="error">File ' . $fileToDelete . ' tidak ditemukan.</p>';
        }
    }
    ?>
</body>
<script src="script.js"></script>
</html>