<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Image Upload</title>
    <style>
        .success {
            color: green;
            font-weight: bold;
            text-align: center;
        }

        .error {
            color: red;
            font-weight: bold;
            text-align: center;
        }
    </style>
</head>
<body>
    <?php
    if (isset($_POST["submit"])) {
        $target_dir = dirname(__FILE__) . '/';
        $target_file = $target_dir . basename($_FILES["file"]["name"]);
        $uploadOk = 1;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        $message = ""; // Inisialisasi pesan

        // Check if image file is a actual image or fake image
        $check = getimagesize($_FILES["file"]["tmp_name"]);
        if ($check !== false) {
            $message = "File is an image - " . $check["mime"];
            $uploadOk = 1;
        } else {
            $message = "File bukan format gambar.<br><br><a href=index.php>sebelumnya</a>";
            $uploadOk = 0;
        }

        // Check file size
        if ($_FILES["file"]["size"] > 500000) {
            $message = "Maaf, ukuran gambar anda melebihi maksimal.<br><br><a href=index.php>sebelumnya</a>";
            $uploadOk = 0;
        }

        // Allow certain file formats
        if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
            && $imageFileType != "gif") {
            $message = "Maaf, hanya JPG, JPEG, PNG & GIF yang di izinkan.<br><br><a href=index.php>sebelumnya</a>";
            $uploadOk = 0;
        }

        // Check if $uploadOk is set to 0 by an error
        if ($uploadOk == 0) {
            $message = "Maaf, pilih gambar terlebih dahulu.<br><br><a href=index.php>sebelumnya</a>";
            echo "<div class='error'>$message</div>";
        } else {
            // Check if the file already exists
            if (file_exists($target_file)) {
                $message = "Maaf, gambar dengan nama tersebut sudah ada.<br><br><a href=index.php>sebelumnya</a>";
                echo "<div class='error'>$message</div>";
            } else {
                // Upload file if everything is ok
                if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
                    $message = "Gambar " . htmlspecialchars(basename($_FILES["file"]["name"])) . " Berhasil di upload.<br><br><a href=index.php>sebelumnya</a>";
                    echo "<div class='success'>$message</div>";
                } else {
                    $message = "Maaf, ada yang error saat mengupload gambar.<br><br><a href=index.php>sebelumnya</a>";
                    echo "<div class='error'>$message</div>";
                }
            }
        }
    }
    ?>
</body>
</html>